

// MARK: - function for one slider

function eqSlider(band, frequency, axFrequency)		// eg for args: "5", "1K", "1kilo"
{
	return {
		nsClass: "GXDrawView",
		gxViewName: "b" + band,
		gxLayout:
		[
			"H:[self(33)]",
			"V:|-0-[self]-0-|",

			"V:|-13-[label(14)]-5-[slider]-6-[readout(14)]-12-|&alignCenterX",
			"H:|-0-[slider]-0-|",
		],
		gxChildViews:
		{
			slider:
			{
				"+": "SliderView.trackUnfilled.vertical",
				gxValueKey: "node.band" + band,
				gxVertical: true,
				gxDetentPainter: fillPainterWithSize("BackColor2", "4, 0.4"),
				gxDefaultValue: 0.5,
				gxDetents: "0.5",
				axFormatter:
				{
					nsClass: "GXScaledFormatter",
					offset: -0.5, scale: 24, format: "%+ .1f dB", zeroFormat: "0dB",
				},
				gxKeystrokeStepSize: 1.0/24.0,
				axTitle: axFrequency + " hertz band",
			},
			label: labelView(frequency, "foreColor1.size10"),
			readout:
			{
				"+": "LabelView.centerx.colorThemeLive1.size11",
				gxValueKey: "node.band" + band,
				gxFormatter: { nsClass: "GXScaledFormatter", offset: -0.5, scale: 24, format: "%.1f", zeroFormat: "0" },
				gxIntrinsicWidth: 38,
				gxClickValue: 0.5,
			}
		}
	};
}


// ------------------------------------------

markup.push({

    
// MARK: - EQ block

Equalizer10Block:
{
	"+": "BlockTemplate",
    geNodeClass: "AHEqualizer10Node",
    h4PresetsId: "EqualizerPresets",
	gxPopoverInfo: "Equalizer10Popover",
	gxTitle: "10-Band EQ",
	gxLibraryDescription: "Fine-tune specific frequencies",
	gxLibraryIcon: "library.10band",
	gxChildViews:
	{
		sparkline:
		{
			nsClass: "GXDrawView",
			gxValueKey: "node.sparklineData",
			gxFrameRect: "18,36,84,43",
			gxForePainter: {
				nsClass: "GXSparklinePainter",
				gxStrokeColor: "ForeColorTheme1",
				gxPointColor: "ForeColorTheme1",
				gxEdgeInsets: "3, 3, 3, 3",	// leave space for points
				gxStrokeWidth: 2.5,
				gxPointDiameter: 3.5,
			}
		},
		presets:
		{
			"+": "BlockPopup.stripMarkup",
			gxFaceModel: {
				nsClass: "H4PresetsFaceModel",
			},
			gxMenuItemsKeyPath: "corePresetsMenuItems",
			axTitle: "Presets",
			axHelp: "Create or use pre-sets for this block",
		},
	},

	geImporterParams: ["node.band0", "node.band1", "node.band2", "node.band3", "node.band4",
					   "node.band5", "node.band6", "node.band7", "node.band8", "node.band9"]
},

// MARK: - EQ popover

Equalizer10Popover:
{
	"+": "PopoverTemplate",
	gxTitle: "10-Band Equalizer",
	gxLayout: [
		"H:|-12-[self]-12-|",
		"V:|-12-[self]-12-|",
		"H:|-0-[group]-0-|",
		"V:|-41-[group]-8-[presetsGroup]"
	],
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		group: {
			"+": "GroupView",
			gxLayout: [
				"V:|-41-[s1]-12-[s2]-12-[s3]-12-[s4]-12-[s5]-12-[s6]-12-[s7]-12-[s8]-12-[s9]-40-|",
				"H:|-49-[b0]-9-[b1]-9-[b2]-9-[b3]-9-[b4]-9-[b5]-9-[b6]-9-[b7]-9-[b8]-9-[b9]-21-|"  // sets popover width
			],
			gxChildViews: [
				// horizontal stripes
				{ gxViewName: "s1", "+": "EqStripe", gxLabelText: "12dB" },
				{ gxViewName: "s2", "+": "EqStripe", gxLabelText: "" },
				{ gxViewName: "s3", "+": "EqStripe", gxLabelText: "6dB" },
				{ gxViewName: "s4", "+": "EqStripe", gxLabelText: "" },
				{ gxViewName: "s5", "+": "EqStripe", gxLabelText: "0dB" },
				{ gxViewName: "s6", "+": "EqStripe", gxLabelText: "" },
				{ gxViewName: "s7", "+": "EqStripe", gxLabelText: "-6dB" },
				{ gxViewName: "s8", "+": "EqStripe", gxLabelText: "" },
				{ gxViewName: "s9", "+": "EqStripe", gxLabelText: "-12dB" },
				// vertical sliders
				eqSlider("0", "32Hz", "32", "32Hz"),
				eqSlider("1", "64", "64", "64"),
				eqSlider("2", "125", "125", "125"),
				eqSlider("3", "250", "250", "250"),
				eqSlider("4", "500", "500", "500"),
				eqSlider("5", "1k", "1kilo", "1k"),
				eqSlider("6", "2k", "2kilo", "2k"),
				eqSlider("7", "4k", "4kilo", "4k"),
				eqSlider("8", "8k", "8kilo", "8k"),
				eqSlider("9", "16kHz", "16kilo", "16kHz"),
			]
		}
	}
},


EqStripe:
{
	nsClass: "GXDrawView",
	gxBackPainter: fillPainter("BackColor2"),
	gxLayout: [ "H:|-5-[selfLabel(35)]-6-[self]-18-|&alignCenterY",
			    "V:[self(0.5)]"
			   ],
	gxLabelTemplate: {
		"+": "LabelView.right.top.darker.size9",
		gxIntrinsicHeight: 14
	}
},

	
// MARK: - Sparkline inline icon painter

PresetSparkCell:
{
	nsClass: "GXTextAttachmentCell",
	gxBaselineOffset: -4,
	gxForePainter: { "+": "PresetSparkPainter" },
	gxDefaultValue: "UFU1P0pEND8dIio/MzMLP+nuFj+wqhI/UFUlP6IGvz5NRnM+6e4WPw==",
},

PresetSparkPainter:
{
	nsClass: "GXSparklinePainter",
	gxStrokeColor: "ForeColor1",
	gxDefaultSize: "26, 16",
	gxEdgeInsets: "1, 0, 3, 0",	// leave space for points, plus more space on right
	gxStrokeWidth: 1.5,
},


// MARK: - EQ presets

EqualizerPresets:
{
    gxBuiltInPresets: [
		{ presetName: "Off (Flat)",     presetValues: {  "band0":0.500000, "band1":0.500000, "band2":0.500000, "band3":0.500000, "band4":0.500000, "band5":0.500000, "band6":0.500000, "band7":0.500000, "band8":0.500000, "band9":0.500000  }},
		{ presetName: "Acoustic",       presetValues: {  "band0":0.708333, "band1":0.704167, "band2":0.664583, "band3":0.543750, "band4":0.589583, "band5":0.572917, "band6":0.645833, "band7":0.670417, "band8":0.647917, "band9":0.589583  }},
		{ presetName: "AirPods",       	presetValues: {  "band0":0.582306, "band1":0.602387, "band2":0.559749, "band3":0.500000, "band4":0.500000, "band5":0.500000, "band6":0.549295, "band7":0.583027, "band8":0.624890, "band9":0.626541  }},
		{ presetName: "Bass Booster",   presetValues: {  "band0":0.729167, "band1":0.677083, "band2":0.645833, "band3":0.604167, "band4":0.552083, "band5":0.500000, "band6":0.500000, "band7":0.500000, "band8":0.500000, "band9":0.500000  }},
		{ presetName: "Bass Reducer",   presetValues: {  "band0":0.270833, "band1":0.322917, "band2":0.354167, "band3":0.395833, "band4":0.447917, "band5":0.500000, "band6":0.500000, "band7":0.500000, "band8":0.500000, "band9":0.500000  }},
		{ presetName: "Classical",      presetValues: {  "band0":0.697917, "band1":0.656250, "band2":0.625000, "band3":0.604167, "band4":0.437500, "band5":0.437500, "band6":0.500000, "band7":0.593750, "band8":0.635417, "band9":0.656250  }},
		{ presetName: "Dance",          presetValues: {  "band0":0.648750, "band1":0.772917, "band2":0.707917, "band3":0.500000, "band4":0.580000, "band5":0.652083, "band6":0.714583, "band7":0.689167, "band8":0.649583, "band9":0.500000  }},
		{ presetName: "Deep",           presetValues: {  "band0":0.706250, "band1":0.647917, "band2":0.572917, "band3":0.541667, "band4":0.618750, "band5":0.604167, "band6":0.560417, "band7":0.410417, "band8":0.352083, "band9":0.308333  }},
		{ presetName: "Electronic",     presetValues: {  "band0":0.677083, "band1":0.658333, "band2":0.550000, "band3":0.500000, "band4":0.410417, "band5":0.593750, "band6":0.535417, "band7":0.552083, "band8":0.664583, "band9":0.700000  }},
		{ presetName: "Hip-Hop",        presetValues: {  "band0":0.708333, "band1":0.677083, "band2":0.562500, "band3":0.625000, "band4":0.458333, "band5":0.458333, "band6":0.562500, "band7":0.479167, "band8":0.583333, "band9":0.625000  }},
		{ presetName: "Jazz",           presetValues: {  "band0":0.666667, "band1":0.625000, "band2":0.562500, "band3":0.593750, "band4":0.437500, "band5":0.437500, "band6":0.500000, "band7":0.562500, "band8":0.625000, "band9":0.656250  }},
		{ presetName: "Latin",          presetValues: {  "band0":0.687500, "band1":0.625000, "band2":0.500000, "band3":0.500000, "band4":0.437500, "band5":0.437500, "band6":0.437500, "band7":0.500000, "band8":0.625000, "band9":0.687500  }},
		{ presetName: "Loudness",       presetValues: {  "band0":0.750000, "band1":0.666667, "band2":0.500000, "band3":0.500000, "band4":0.416667, "band5":0.500000, "band6":0.458333, "band7":0.291667, "band8":0.708333, "band9":0.541667  }},
		{ presetName: "Lounge",         presetValues: {  "band0":0.375000, "band1":0.437500, "band2":0.479167, "band3":0.562500, "band4":0.666667, "band5":0.604167, "band6":0.500000, "band7":0.437500, "band8":0.583333, "band9":0.541667  }},
		{ presetName: "Piano",          presetValues: {  "band0":0.625000, "band1":0.583333, "band2":0.500000, "band3":0.604167, "band4":0.625000, "band5":0.562500, "band6":0.645833, "band7":0.687500, "band8":0.625000, "band9":0.645833  }},
		{ presetName: "Pop",            presetValues: {  "band0":0.437500, "band1":0.458333, "band2":0.500000, "band3":0.583333, "band4":0.666667, "band5":0.666667, "band6":0.583333, "band7":0.500000, "band8":0.458333, "band9":0.437500  }},
		{ presetName: "R&B",            presetValues: {  "band0":0.609167, "band1":0.788333, "band2":0.735417, "band3":0.555417, "band4":0.408750, "band5":0.437500, "band6":0.596667, "band7":0.610417, "band8":0.625000, "band9":0.656250  }},
		{ presetName: "Rock",           presetValues: {  "band0":0.708333, "band1":0.666667, "band2":0.625000, "band3":0.562500, "band4":0.479167, "band5":0.458333, "band6":0.520833, "band7":0.604167, "band8":0.645833, "band9":0.687500  }},
		{ presetName: "Small Speakers", presetValues: {  "band0":0.729167, "band1":0.677083, "band2":0.645833, "band3":0.604167, "band4":0.552083, "band5":0.500000, "band6":0.447917, "band7":0.395833, "band8":0.354167, "band9":0.322917  }},
		{ presetName: "Spoken Word",    presetValues: {  "band0":0.355833, "band1":0.480417, "band2":0.500000, "band3":0.528750, "band4":0.644167, "band5":0.692083, "band6":0.701667, "band7":0.678333, "band8":0.605833, "band9":0.500000  }},
		{ presetName: "Treble Booster", presetValues: {  "band0":0.500000, "band1":0.500000, "band2":0.500000, "band3":0.500000, "band4":0.500000, "band5":0.552083, "band6":0.604167, "band7":0.645833, "band8":0.677083, "band9":0.729167  }},
		{ presetName: "Treble Reducer", presetValues: {  "band0":0.500000, "band1":0.500000, "band2":0.500000, "band3":0.500000, "band4":0.500000, "band5":0.447917, "band6":0.395833, "band7":0.354167, "band8":0.322917, "band9":0.270833  }},
		{ presetName: "Vocal Booster",  presetValues: {  "band0":0.437500, "band1":0.375000, "band2":0.375000, "band3":0.562500, "band4":0.656250, "band5":0.656250, "band6":0.625000, "band7":0.562500, "band8":0.500000, "band9":0.437500  }}
	],
},


})
